/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Blocks.AEParts;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.items.parts.PartModels;
import appeng.me.helpers.MachineSource;
import appeng.parts.automation.AnnihilationPlanePart;
import appeng.parts.automation.PlaneModels;
import com.hoshino.cti.register.CtiItem;
import com.hoshino.cti.util.CommonUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class MeteoriumAnnihilationPlanePart
extends AnnihilationPlanePart {
    private static final PlaneModels MODELS = new PlaneModels("part/meteorium_annihilation_plane", "part/meteorium_annihilation_plane_on");
    private final IActionSource actionSource = new MachineSource((IActionHost)this);
    private boolean rightPlace = false;
    public int process = 0;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public void addToWorld() {
        super.addToWorld();
        BlockEntity host = this.getBlockEntity();
        if (host.m_58898_()) {
            int buildHeight = host.m_58904_().m_151558_();
            if (host.m_58899_().m_123342_() + 1 >= buildHeight && this.getSide() == Direction.UP) {
                this.rightPlace = true;
            }
        }
    }

    public MeteoriumAnnihilationPlanePart(IPartItem<?> partItem) {
        super(partItem);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isActive() && this.rightPlace) {
            this.process += ticksSinceLastCall;
            BlockEntity host = this.getBlockEntity();
            if (this.process > 1000 && host.m_58904_() != null && CommonUtil.isAetherNight(host.m_58904_())) {
                Optional.ofNullable((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("kubejs:aetheric_meteorite_ore"))).ifPresent(item -> this.insertToGrid((AEKey)AEItemKey.of((ItemStack)new ItemStack((ItemLike)item)), 1L, Actionable.MODULATE));
                this.process = 0;
            }
            if (this.process > 2000) {
                this.insertToGrid((AEKey)AEItemKey.of((ItemStack)new ItemStack((ItemLike)CtiItem.meteorite_ore.get())), 1L, Actionable.MODULATE);
                this.process = 0;
            }
            return TickRateModulation.IDLE;
        }
        return TickRateModulation.SLEEP;
    }

    public long insertToGrid(AEKey what, long amount, Actionable mode) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return 0L;
        }
        return StorageHelper.poweredInsert((IEnergySource)grid.getEnergyService(), (MEStorage)grid.getStorageService().getInventory(), (AEKey)what, (long)amount, (IActionSource)this.actionSource, (Actionable)mode);
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

